<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * SiteController
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class AdlistController extends Controller
{
    public function actionIndex($slug=null)
    {
	
     $order ="";
	 $order_val ="";
	 if(isset($_GET['order']) and in_array($_GET['order'],array(1,2,3,4)))
	 {
		 if($_GET['order']=="1") {  $order ="price asc,"; }
		 if($_GET['order']=="2") {  $order ="price desc,"; }
		 if($_GET['order']=="3") {  $order ="t.added_date asc,"; }
		 if($_GET['order']=="4") {  $order ="t.added_date desc,"; }
		 $order_val = $_GET['order']; 
	 }
	 
	// $model = PlaceAnAd::model()->listDataFromSlug($slug);
	 $criteria=new CDbCriteria;
	 $criteria->condition = "t.isTrash='0' and t.status='A'";
	 $criteria->with = array("subCategory"=>array("on"=>"subCategory.isTrash='0' and subCategory.status='A'","condition"=>"subCategory.slug=:sname","params"=>array(":sname"=>$slug),'joinType'=>'INNER JOIN'));
	 $count=PlaceAnAd::model()->count($criteria);
	 $pages=new CPagination($count);
	 $pages->pageSize=10;
	 $pages->applyLimit($criteria);
	 $criteria->order ="{$order}featured='Y' desc,t.priority desc,t.id desc";
	 $model=PlaceAnAd::model()->findAll($criteria);
	 $subcategory= Subcategory::model()->findByAttributes(array('slug'=>$slug));
	 if(empty($subcategory))
	 {
		  
		throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
	 }
	 
	// $subcategory = Subcategory::model()->getSubCategoryOne($attributes['sub_category_id']);
 	$fields=array();
	$fields=  ($subcategory->change_parent_fields=="N") ? CHtml::listData($subcategory->category->relatedFields,'field_name','field_name'):CHtml::listData($subcategory->relatedFields,'field_name','field_name');
 

	 $this->setData(array(
                    'pageMetaTitle'         => Yii::t('app', '{name} :: home', array('{name}' => Yii::app()->name )), 
                    'pageMetaDescription'   => Yii::app()->params['description'],
                    'head'=>$subcategory->sub_category_name,
                ));
	 $this->render("index",compact("model","fields","pages","order_val","subcategory"));
    }
    
    public function actionOffline()
    {
        if (Yii::app()->options->get('system.common.site_status') !== 'offline') {
            $this->redirect(array('site/index'));
        }
        
        throw new CHttpException(503, Yii::app()->options->get('system.common.site_offline_message'));
    }
    
    public function actionError()
    {
		 
        if ($error = Yii::app()->errorHandler->error) {
            if (Yii::app()->request->isAjaxRequest) {
                echo CHtml::encode($error['message']);
            } else {
                $this->setData(array(
                    'pageMetaTitle'         => Yii::t('app', 'Error {code}!', array('{code}' => $error['code'])), 
                    'pageMetaDescription'   => $error['message'],
                ));
                $this->render('error', $error) ;
            }    
        }
    }
 

}
